#!/usr/bin/perl
#
# add2jsgal.pl v0.11 - add images to gallery 
#
# Copyright (c) 2005 by Andreas S. Krebs (jsgal@sberk.net)
#
# this script automatically saves a resized version of the image and a thumb of
# the image in the folders specified by the gallery xml file and finally updates
# the xml itself
#

use Getopt::Std;
use XML::DOM;
use Image::Magick;

$IMAGE_SIZE="1024x768";
$IMAGE_QUAL=85;
$THUMB_SIZE="200x150";
$THUMB_QUAL=75;

$USAGE="Usage: add2jsgal.pl -g gallery image ...\n";

getopts('g:') or die $USAGE;

if($#ARGV < 0 || !defined $opt_g)
{
  print $USAGE;
  exit 0;
}

# first load the gallery
my $parser=new XML::DOM::Parser;
my $gallery=$parser->parsefile($opt_g);
my $imgsnode=$gallery->getElementsByTagName("images")->item(0);

my $imagesdir=$imgsnode->getAttribute("imagesdir");
my $thumbsdir=$imgsnode->getAttribute("thumbsdir");

#now add the new files to the gallery
foreach $file (@ARGV)
{
  my $image=new Image::Magick;
  my $x=$image->Read($file);
  
  if($x)
  {
    warn $x;
  }
  else
  {
    my $name=$file;

    # get the name of the image
    $name=~s/.*\///;
    $name=~s/.*\\//;
    $name=~s/.*://;

    # new get ride of Exif data in APP1 profile
#    $image->Profile(name=>"APP1");
    $image->Profile(name=>"*");

    # now create the image
    scaleImage($image, $IMAGE_SIZE, $IMAGE_QUAL, "$imagesdir/$name");

    # now create the thumg
    scaleImage($image, $THUMB_SIZE, $THUMB_QUAL, "$thumbsdir/$name");

    # now add image to DOM (and also add text nodes for pretty printing - until we find a better solution)
    my $imgtag=$gallery->createElement("image");
    $imgtag->setAttribute("file", $name);
    $imgsnode->appendChild($gallery->createTextNode("  "));
    $imgsnode->appendChild($imgtag);
    $imgsnode->appendChild($gallery->createTextNode("\n  "));
  }

  undef $image;
}

#write gallery again
print "Updating: $opt_g\n";
$gallery->printToFile ($opt_g);
$gallery->dispose;

1;

sub scaleImage
{
  my($img,$geom,$qual,$outfile)=@_;

  my($w,$h)=split('x',$geom);
  my $imgw=$img->Get('width');
  my $imgh=$img->Get('height');

  my $x;

  if($imgw>$w || $imgh>$h)
  {
    $img=$img->Clone();

    $x=$img->Scale($geom);
    warn $x if $x;
  }
  else
  {
    $geom=$imgw."x".$imgh;
  }

  print "  Creating: $outfile ($geom)\n";
  $img->Set(quality=>$qual);
  $x=$img->Write($outfile);
  warn $x if $x;

  undef $img;
}
