/* JSGal v0.65: Copyright (c) 2004-2005 by Andreas S. Krebs (jsgal@sberk.net) */
// below are the gallery parameter (may be changed in the xml file)
var imgrows=3;
var imgcols=3;
var pagesinrow=20;
var thumbheight=150;	// if you change this you probably also want to change the heigth of the thumbcell in the styles!!
var thumbwidth=null;	// use null to resize keeping aspect ratio
var thumbcellw=212;
var thumbcellh=174;
var imageheight=600;
var imagewidth=null;	// use null to resize keeping aspect ratio
var imagetarget=null;	// the target browser window name for displaying original image or null for current window
var imagecellw=840;
var imagecellh=640;

var title=null;
var images=new Array();	// the array for the images
var thumbs=new Array(); // the array for the thumbs
var titles=new Array(); // the array for the image titles
var descriptions=new Array();	// the array with the image descriptions

var galleries=new Array();	// the array for the gallery xml file
var galtitles=new Array();	// the array with the gallery titles
var curMode=new Array();	// the array with the current mode for the galeries
var curImgs=new Array();	// the array with the current image for the galeries

var imgspage;
var numpages;
var numpagerows;
var slideTimeout;

// here are all the texts we use
var TXT_PREVIOUS="Previous";
var TXT_SHOWALL="Show All";
var TXT_NEXT="Next";
var TXT_ORIGSIZE="Original size...";

var TXT_MSG_LOADGALS="loading galleries ...";
var TXT_ERR_LOADGALS="error loading gallery: ";
var TXT_MSG_LOADGAL="loading gallery ...";
var TXT_ERR_LOADGAL="error loading gallery: ";

// here are the display modes
var MODE_PAGE		=1;
var MODE_SHOWALL	=2;
var MODE_IMAGE		=3;

// here are the variables we store the current values in
var current_mode	=-1;
var current_page	=-1;
var current_image	=-1;
var current_gallery	=null;

function showPage(page)
{
  if(page>numpages)
    page=numpages;

  if(page<1)
    page=1;

  renderPage(MODE_PAGE, page, -1);

  disableSlideshow();
}

function showAll()
{
  renderPage(MODE_SHOWALL, -1, -1);

  disableSlideshow();
}

function showImage(imgno)
{
  if(imgno>=images.length)
    imgno=images.length-1;

  if(imgno<0)
    imgno=0;

  renderPage(MODE_IMAGE, Math.floor(imgno/imgspage)+1, imgno);

  disableSlideshow();
}

var waitImg;
function waitForImg()
{
  if(!waitImg.complete)
    setTimeout("waitForImg();", 200);
  else
  {
    slideTimeout=setTimeout("nextSlide(1);", document.getElementById("delaysel").value*1000);

    // let's also preload the next image
    var imgno=current_image+1;

    if(imgno>=images.length)
      imgno=0;

    waitImg.src=images[imgno];
  }
}

function nextSlide(incr)
{
  if(slideTimeout)
    clearTimeout(slideTimeout);

  var el=document.getElementById("slideshow");

  if(el.checked && images.length>0)
  {
    var imgno=(current_image<0) ? incr : (current_image+incr);

    if(imgno>=images.length)
      imgno=0;

    // since image.complete only works once, we have to create a new image here
    
    waitImg=new Image();
    waitImg.src=images[imgno];

    renderPage(MODE_IMAGE, Math.floor(imgno/imgspage)+1, imgno);

    // now let's wait for the image to load
    waitForImg();
  }
  else
    disableSlideshow();
}

function disableSlideshow()
{
  var el=document.getElementById("slideshow");

  if(el.checked)
    document.getElementById("slideshow").checked=false;
}

function appendSimpleElement(parent, id, tag)
{
  var el=document.createElement(tag);

  if(id)
    setAttribute(el, 'id', id);
    
  if(parent)
    parent.appendChild(el);

  return el;
}

function appendText(parent, text)
{
  var el=document.createTextNode(text);

  if(parent)
    parent.appendChild(el);

  return el;
}

function updateText(parentId, text)
{
  var el=document.getElementById(parentId);

  // note: we expect the text element to be the first element !!!
  if(el && el.firstChild && el.firstChild.nodeType==3)
    el.firstChild.nodeValue=text;
}

/* this a workaround for the bugs in IE's setAttribute */
function setAttribute(node, name, value) 
{
  // to be on the save side we always set attributes again
  try
  {
    if(value)
    {
      var attr=document.createAttribute(name);
      attr.value=value;

      node.setAttributeNode(attr);
    }
    else
      node.removeAttribute(name);
  }
  catch(e)
  {
    alert("failed to set attribute "+name+"="+value+"at node:\n"+e);
  }
} 

function updateAttributes(elId)
{
  var el=document.getElementById(elId);

  if(el)
  {
    for(var i=1; (i+1)<arguments.length; i+=2) 
    {
      if(el.getAttribute(arguments[i])!=arguments[i+1])
        setAttribute(el, arguments[i], arguments[i+1]);
    }
  }
}

function appendElement(parent, id, tag, text)
{
  var el=appendSimpleElement(parent, id, tag);

  for(var i=4; (i+1)<arguments.length; i+=2) 
  {
    setAttribute(el, arguments[i], arguments[i+1]);
  }

  if(text)
    appendText(el, text);

  return el;
}

function appendGalleryLink(parent, id, galno)
{
  return appendElement(parent, id, "a", galtitles[galno], "class", "enabled", "href", "javascript:showGallery('"+galleries[galno]+"', MODE_PAGE, 1, -1);");
}

function updateGalleryLink(elId, galno)
{
  var st, ref;
 
  var cimg=curImgs[galleries[galno]];
  var cmode=curMode[galleries[galno]];

  if(!cimg)
    cimg=1;

  if(!cmode)
    cmode=MODE_PAGE;
 
  if(galno>=0 && galno<galleries.length)
  {
    st="enabled";
    ref="javascript:showGallery('"+galleries[galno]+"', "+cmode+", -1, "+cimg+");";
  }
  else
  {
    st="disabled";
    ref=null;
  }
  
  updateAttributes(elId, "class", st, "href", ref);
}

function appendNavLink(parent, id, title, page, current)
{
  if(page>=1 && page<=numpages)
    return appendElement(parent, id, "a", title, "class", current ? "current" : "enabled", "href", "javascript:showPage("+page+");");
  else
    return appendElement(parent, id, "a", title, "class", "disabled");
}

function updateNavLink(elId, page, current)
{
  var st, ref;

  if(page>=1 && page<=numpages)
  {
    st=current ? "current" : "enabled";
    ref="javascript:showPage("+page+");";
  }
  else
  {
    st="disabled";
    ref=null;
  }

  updateAttributes(elId, "class", st, "href", ref);
}

function appendShowallLink(parent, id, title)
{
  return appendElement(parent, id, "a", title, "class", "enabled", "href", "javascript:showAll();");
}

function appendImageNavLink(parent, id, title, imgno)
{
  if(imgno>=0 && imgno<images.length)
    return appendElement(parent, id, "a", title, "class", "enabled", "href", "javascript:showImage("+imgno+");");
  else
    return appendElement(parent, id, "a", title, "class", "disabled");
}

function updateImageNavLink(elId, imgno)
{
  var st, ref;

  if(imgno>=0 && imgno<images.length)
  {
    st="enabled";
    ref="javascript:showImage("+imgno+");";
  }
  else
  {
    st="disabled";
    ref=null;
  }

  updateAttributes(elId, "class", st, "href", ref);
}

function appendImageLink(parent, id, imgno)
{
  var imgsrc, visible, title;

  if(imgno>=images.length)
  {
    imgsrc=null;
    visible=false;
    title=" ";
  }
  else
  {
    imgsrc=thumbs[imgno];
    visible=true;
    title=titles[imgno];
  }

  var el=appendElement(parent, id, "a", null, "class", "enabled", "href", "javascript:showImage("+imgno+");");
  appendElement(el, id+"_img", "img", null, "class", "thumb", "src", imgsrc, "width", thumbwidth, "height", thumbheight);
  appendSimpleElement(el, id+"_br", "br");
  appendElement(el, id+"_span", "span", title, "class", "thumbfooter");

  setElementVisible(el, visible);
} 

function updateImageLink(elId, imgno)
{
  var imgsrc=thumbs[imgno];
  var visible=true;

  if(imgno>=images.length)
  {
    imgsrc=null;
    visible=false;
  }

  var el=document.getElementById(elId);
  setAttribute(el, "href", "javascript:showImage("+imgno+");");
  updateAttributes(elId+"_img", "src", imgsrc, "width", thumbwidth, "height", thumbheight);
  updateText(elId+"_span", titles[imgno]);

  setElementVisible(el, visible);
}

function setElementVisible(el, visible)
{
  var disp=visible ? "" : "none";

  if(el && el.style.display!=disp)
    el.style.display=disp;
}

function replaceNodes(elId, childEl)
{
  if(childEl)
  {
    var el=document.getElementById(elId);

    if(el)
    {
      if(el.firstChild)
      {
        if(childEl)
          el.replaceChild(childEl, el.firstChild);
        else
          el.removeChild(el.firstChild);
      }
      else if(childEl)
        el.appendChild(childEl);
    }
  }
}

function createNavigation(mode, pageno)
{
  var rowEl, colEl, bodyEl, navEl;
  var prevStyle=(pageno>1) ? "navpage" : "navpage_disabled";
  var nextStyle=(pageno<numpages) ? "navpage" : "navpage_disabled";

  // check if really a create is required or maybe a simple update will do 
  if(mode==current_mode || (mode!=MODE_SHOWALL && (current_mode==MODE_IMAGE || current_mode==MODE_PAGE)))
  {
    if(mode!=current_mode || current_page!=pageno)
    {
      updateAttributes("pg_prev", "class", prevStyle);
      updateNavLink("pg_prev_link", pageno-1, false);

      updateAttributes("pg_next", "class", nextStyle);
      updateNavLink("pg_next_link", pageno+1, false);

      if(current_page!=pageno)
      {
        updateAttributes("pg_"+current_page, "class", "jumppage");
        updateNavLink("pg_"+current_page+"_link", current_page, false);
      }

      updateAttributes("pg_"+pageno, "class", "jumppage_active");
      updateNavLink("pg_"+pageno+"_link", (mode==MODE_PAGE) ? -1 : pageno, true);
    }

    return null;
  }

  // now let's create the navigation
  navEl=appendElement(null, "ntab", "table", null, "class", "navigation", "width", "100%");
  bodyEl=appendSimpleElement(navEl, "ntab_tb", "tbody");

  // create the with page links
  var inx=1;
  for(var r=0; r<numpagerows; r++)
  {
    rowEl=appendSimpleElement(bodyEl, "ntab_tr"+r, "tr");

    // create the previous link in first row
    if(r==0 && mode!=MODE_SHOWALL && numpages>1)
    {
      colEl=appendElement(rowEl, "pg_prev", "td", null, "class", prevStyle, "rowspan", numpagerows);
      appendNavLink(colEl, "pg_prev_link", TXT_PREVIOUS, pageno-1, false);
    }

    for(var i=0; i<pagesinrow && inx<=numpages; i++, inx++)
    {
      var style=(inx==pageno) ? "jumppage_active" : "jumppage";	  // is this the current page ?
      var pgn=((inx==pageno) && (mode==MODE_PAGE)) ? -1 : inx;    // in page mode we don't create a link

      colEl=appendElement(rowEl, "pg_"+inx, "td", null, "class", style);
      appendNavLink(colEl, "pg_"+inx+"_link", inx, pgn, inx==pageno);
    }

    // create the next link in first row
    if(r==0 && mode!=MODE_SHOWALL && numpages>1)
    {
      if(numpages>1)
      {
        colEl=appendElement(rowEl, "showall", "td", null, "class", "showAll", "rowspan", numpagerows);
        appendShowallLink(colEl, "showall_link", TXT_SHOWALL);
      }

      colEl=appendElement(rowEl, "pg_next", "td", null, "class", nextStyle, "rowspan", numpagerows);
      appendNavLink(colEl, "pg_next_link", TXT_NEXT, pageno+1, false);
    }
  }

  return navEl;
}

function createThumbGallery(mode, pageno)
{
  var rowEl, colEl, bodyEl, mainEl;

  // create the page with thumbs
  var imgno=(pageno-1)*imgspage;

  // check if really a create is required or maybe a simple update will do 
  if(mode==current_mode)
  {
    if(mode!=MODE_SHOWALL && pageno!=current_page)
    {
      for(var row=0; row<imgrows; row++)
      {
        for(var col=0; col<imgcols; col++)
        {
          updateImageLink("img_"+row+"_"+col+"_link", imgno);

          imgno++;
        }
      }
    }

    return null;
  }

  var numrows=imgrows;

  // now let's create the image section
  mainEl=appendElement(null, "gtab", "table", null, "class", "gallery", "width", "100%");
  bodyEl=appendSimpleElement(mainEl, "gtab_tb", "tbody");

  // for showAll we simply increase the rows per page, so that all thumbs fit
  if(mode==MODE_SHOWALL)
  {
    imgno=0;
    numrows=Math.ceil(images.length/imgcols);
  }

  // create rows and cell with thumbs
  for(var row=0; row<numrows; row++)
  {
    rowEl=appendSimpleElement(bodyEl, "gtab_tr"+row, "tr");

    for(var col=0; col<imgcols; col++)
    {
      var id="img_"+row+"_"+col;

      colEl=appendElement(rowEl, id, "td", null, "class", "thumbcell", "width", thumbcellw, "height", thumbcellh);
      appendImageLink(colEl, id+"_link", imgno);

      imgno++;
    }
  }
 
  return mainEl;
}

function createImageGallery(mode, imgno)
{
  var aEl, rowEl, colEl, bodyEl, mainEl;
  var prevStyle=(imgno>0) ? "img_navpage" : "img_navpage_disabled";
  var nextStyle=(imgno<images.length-1) ? "img_navpage" : "img_navpage_disabled";

  // check if really a create is required or maybe a simple update will do
  if(mode==current_mode)
  {
    updateAttributes("img_prev", "class", prevStyle);
    updateImageNavLink("img_prev_link", imgno-1);

    updateText("image_name", titles[imgno]);

    updateAttributes("img_next", "class", nextStyle);
    updateImageNavLink("img_next_link", imgno+1);
       
    updateAttributes("img_nameref", "href", images[imgno]);
    updateAttributes("img_imgref", "src", images[imgno], "width", imagewidth, "height", imageheight);
    updateText("img_os", descriptions[imgno]);

    return null;
  }

  // now let's create the image section
  mainEl=appendElement(null, "gtab", "table", null, "class", "gallery", "width", "100%");
  bodyEl=appendSimpleElement(mainEl, "gtab_tb", "tbody");

  // create the page with the image
  rowEl=appendSimpleElement(bodyEl, "gtab_tr0", "tr");

  // create the link for previous image
  colEl=appendElement(rowEl, "img_prev", "td", null, "class", prevStyle);
  appendImageNavLink(colEl, "img_prev_link", TXT_PREVIOUS, imgno-1);

  // display image name in the middle
  appendElement(rowEl, "image_name", "td", titles[imgno], "class", "img_jumppage_active");

  // create the link for next image
  colEl=appendElement(rowEl, "img_next", "td", null, "class", nextStyle);
  appendImageNavLink(colEl, "img_next_link", TXT_NEXT, imgno+1);

  // create the row with the image cell
  rowEl=appendSimpleElement(bodyEl, "gtab_tr1", "tr");
  colEl=appendElement(rowEl, "gtab_img", "td", null, "class", "picturecell", "colspan", 3, "width", imagecellw, "heigth", imagecellh);

  // create a link link to the image containing the image
  aEl=appendElement(colEl, "img_nameref", "a", null, "class", "enabled", "href", images[imgno], "target", imagetarget);
  appendElement(aEl, "img_imgref", "img", null, "class", "picture", "src", images[imgno], "width", imagewidth, "height", imageheight);
  appendSimpleElement(aEl, "img_br", "br");
  appendElement(aEl, "img_os", "span", descriptions[imgno], "class", "picturefooter");

  return mainEl;
}

// this method renders the complete page (for all modes)
function renderPage(mode, pageno, imgno)
{ 
  var navEl, mainEl;

  // we only set the title if the mode is initial
  if(current_mode<0)
  {
    var titleEl=appendText(null, title);

    replaceNodes("title", titleEl);
  }

  // create the navigation area
  navEl=createNavigation(mode, pageno);
  replaceNodes("nav", navEl);

  // create the gallery area
  if(mode!=MODE_IMAGE)		// page or showall mode
    mainEl=createThumbGallery(mode, pageno, imgno);
  else
    mainEl=createImageGallery(mode, imgno);
  replaceNodes("main", mainEl);

  // now update the variables with the current values
  current_mode=mode;
  current_page=pageno;
  current_image=imgno;

  // now let's save the state in the cookie
  updateJsgalCookie();
}

function renderGalleries()
{
  var colEl, rowEl, bodyEl, galsEl=null;

  // we only render the galleries area if there are at least 2 of them
  if(galleries.length>1)
  {
    galsEl=appendElement(null, "gstab", "table", null, "class", "gallerysel", "cellspacing", "0");
    bodyEl=appendSimpleElement(galsEl, "gstab_tb", "tbody");

    for(var i=0; i<galleries.length; i++)
    {
      var style=(galleries[i]==current_gallery) ? "navgal_active" : "navgal";
 
      rowEl=appendSimpleElement(bodyEl, "gstab_tr"+i, "tr");
      colEl=appendElement(rowEl, "gstab_tr"+i+"_td", "td", null, "class", style);

      appendGalleryLink(colEl, "gallery_"+i, i);
    }
  }

  // now add the nodes to the DOM
  replaceNodes("gals", galsEl);
}

function updateGalleries(gallery)
{
  if(galleries.length>1)
  {
    for(var i=0; i<galleries.length; i++)
    {
      if(galleries[i]==current_gallery)		// mark as no longer active
      {
        updateAttributes("gstab_tr"+i+"_td", "class", "navgal");
        updateGalleryLink("gallery_"+i, i);
      }
      if(galleries[i]==gallery)			// mark as active
      {
        updateAttributes("gstab_tr"+i+"_td", "class", "navgal_active");
        updateGalleryLink("gallery_"+i, -1);
      }
    }
  }

  // now we have to set the state variables
  current_mode=-1;
  current_page=-1;
  current_image=-1;
  current_gallery=gallery;
}

function showMessage(msg)
{
  replaceNodes("title", appendText(null, msg));
}

var JSCOOKIE="jsstyle";

function updateJsgalCookie()
{
  var imgno=(current_mode==MODE_PAGE) ? (current_page-1)*imgspage : current_image;
  // we no longer store the current page, but the first image to allow resizing
  var ck=document.getElementById('styletag').getAttribute('href')+","+current_mode+",-1,"+imgno+","+current_gallery;
  var dt=new Date();

  // update values for current gallery before creating cookie
  curImgs[current_gallery]=imgno;
  curMode[current_gallery]=current_mode;
  for(var i=0; i<galleries.length; i++)
  {
    if(curImgs[galleries[i]] && curMode[galleries[i]])
      ck+=","+galleries[i]+"#"+curMode[galleries[i]]+"#"+curImgs[galleries[i]];
  }

  dt.setFullYear(dt.getFullYear()+1);	// let's set the cookie expiry time 1 year in the future
  
  document.cookie=JSCOOKIE+"="+escape(ck)+"; expires="+dt.toGMTString();  
}

function getJsgalCookie()
{
  var s=document.cookie;
  var inx=s.indexOf(JSCOOKIE+"=");

  if(inx<0)
    return null;
  
  s=s.substring(inx+JSCOOKIE.length+1, s.length);

  inx=s.indexOf(";");
  if(inx>0)
    s=s.substring(0, inx);

  return unescape(s); 
}

function restoreState()
{
  // first let's try to load the galleries
  loadGalleries(document.getElementById("galleries").getAttribute("href"));

  try
  {
    var ck=getJsgalCookie();
    var cssfile, gallery, mode=MODE_PAGE, page=-1, imgno=1, imgsp=-1;

    if(ck)
    {
      var cks=ck.split(",");
   
      cssfile=cks[0];
      if(cks.length>=4)
      {
        mode=parseInt(cks[1]);
        page=parseInt(cks[2]);
        imgno=parseInt(cks[3]);

        if(cks.length>=5)
          gallery=cks[4];
      } 

      for(var i=5; i<cks.length; i++)
      {
        var gis=cks[i].split("#");

        if(gis.length==3)
        {
          curMode[gis[0]]=parseInt(gis[1]);
          curImgs[gis[0]]=parseInt(gis[2]);
        }
      }
    }
    else
      cssfile=document.getElementById('styletag').getAttribute('href');

    setStyle(cssfile);

    // now select style in combo box
    var opts=document.getElementById("stylesel").options;
    for(var i=0; i<opts.length; i++)
      opts[i].selected=(opts[i].value==cssfile);

    // load gallery if not current one
    if(!gallery && galleries.length>0)
      gallery=galleries[0];

    // now restore the state of the page
    if(gallery)
      showGallery(gallery, mode, page, imgno);
  }
  catch(e)
  {
    // if anything goes wrong we restore the first page
    showPage(1);
  }
}

function showGallery(gallery, mode, page, imgno)
{
  if(loadGallery(gallery))
  {
    updateGalleries(gallery);

    if(mode==MODE_IMAGE)
      showImage(imgno);
    else if(mode==MODE_SHOWALL)
      showAll();
    else
    {
      if(page<1)	// if no page provide the imgno is the number of the first image
        page=Math.floor(imgno/imgspage)+1;

      showPage(page);
    }
  }
}

function setStyle(cssfile)
{
  var st=document.getElementById('styletag');
  st.setAttribute('href', cssfile);

  // now let's save the style in the cookie
  updateJsgalCookie();
}

function loadGalleries(galsUrl)
{
  showMessage(TXT_MSG_LOADGALS);

  try
  {
    var xmlDoc=parseDocument(galsUrl);
  
    var gals=xmlDoc.getElementsByTagName("gallery");
    galleries=new Array(gals.length);
    galtitles=new Array(gals.length);

    for(var i=0; i<gals.length; i++)
    {
      var file=gals[i].getAttribute("file");

      galleries[i]=file;
      galtitles[i]=(gals[i].firstChild) ? gals[i].firstChild.nodeValue : file;
    }
 
    renderGalleries(xmlDoc, current_gallery);
  }
  catch(e)
  {
    showMessage(TXT_ERR_LOADGALS+e);
    return false;
  }
}

function loadGallery(galurl)
{
  showMessage(TXT_MSG_LOADGAL);

  try
  {
    var xmlDoc=parseDocument(galurl);

    parseGallery(xmlDoc);

    updateGallerySize();
  }
  catch(e)
  {
    showMessage(TXT_ERR_LOADGAL+e);
    return false;
  }

  return true;
}

var origcols;
var origrows;
function updateGallerySize()
{
  var evh=null;

  origcols=imgcols;
  origrows=imgrows;

  if(imgcols<1 || imgrows<1) 
    evh=recalcGallerySize;

  // now let's handle the case were we should try to find optimal number of thumbs per page
  if(thumbwidth || thumbheight)
  {
    // the whole calculation is a best guess, since otherwise we would have to take the actual image
    // sizes and the current style sheet into account

    if(imgcols<1)
    {
      var tw=(thumbwidth) ? thumbwidth : (thumbheight*4)/3;                   // we expect 4x3 sizes if no width specified
      var bw=getBrowserWidth()*0.8;		// we only use 80% of width for gallery

      tw+=10;         // for a bit of border between the images

      imgcols=Math.floor(bw/tw);
    }

    if(imgrows<1)
    {
      var th=(thumbheight) ? thumbheight : (thumbwidth*3)/4;                   // we expect 4x3 sizes if no width specified
      var ch=Math.max(document.getElementById("main").offsetHeight, document.getElementById("gals").offsetHeight);
      var bh=getBrowserHeight()-document.getElementById("docbody").offsetHeight+ch;

      th+=40;         // for a bit of border and the image description below
      bh*=0.9;        // we use only 90% here

      imgrows=Math.floor(bh/th);
    }
  }

  if(imgcols<1)
    imgcols=1;

  if(imgrows<1)
    imgrows=1;

  // now let's update the remaining variables
  imgspage=imgrows*imgcols;
  numpages=Math.ceil(images.length/imgspage);
  numpagerows=Math.ceil(numpages/pagesinrow);

  // now set event handler for resize
  window.onresize=evh;
}

function recalcGallerySize()
{
  var oldcols=imgcols;
  var oldrows=imgrows;
  var pimgno=(current_page-1)*imgspage;

  imgcols=origcols;
  imgrows=origrows;

  updateGallerySize();

  if(imgcols!=oldcols || imgrows!=oldrows)
  {
    // something has changed so we have to redraw the gallery
    var mode=current_mode;
    var imgno=current_image;
    
    current_mode=-1;
    current_page=-1;

    if(mode==MODE_IMAGE)
      showImage(imgno);
    else if(mode==MODE_SHOWALL)
      showAll();
    else
      showPage(Math.floor(pimgno/imgspage)+1);
  }
}


function parseDocument(docurl)
{
  var xmlDoc;

  // first create an xml document using the mozilla or IE way
  if(document.implementation && document.implementation.createDocument)
    xmlDoc=document.implementation.createDocument("", "", null);
  else if(window.ActiveXObject)
    xmlDoc=new ActiveXObject("Microsoft.XMLDOM");
  else
    throw "Error: XML data loading not supported by your browser";

  xmlDoc.async=false;
  xmlDoc.load(docurl);

  if(xmlDoc.parseError)		// handle IE errors
  {
    if(xmlDoc.parseError.errorCode!=0)
      throw xmlDoc.parseError.reason;
  }
  else if(xmlDoc.documentElement.tagName=="parsererror")	// handle mozilla errors
  {
      throw xmlDoc.documentElement.firstChild.nodeValue;
  }

  if(!xmlDoc.firstChild)
    throw "Error: failed to get XML document from "+docurl;

  return xmlDoc;
}

function parseGallery(xmlDoc)
{
  var thumbdir="";
  var imagedir="";

  // parse the document and set the javascript variables
  var el=getFirstElement(xmlDoc, "title");

  if(el && el.firstChild)
    title=el.firstChild.nodeValue;

  el=getFirstElement(xmlDoc, "thumbs");
  if(el)
  {
    imgrows=getIntAttribute(el, "rows", imgrows);
    imgcols=getIntAttribute(el, "columns", imgcols);
    pagesinrow=getIntAttribute(el, "pagesinrow", pagesinrow);
    thumbwidth=getIntAttribute(el, "width", thumbwidth);
    thumbheight=getIntAttribute(el, "height", thumbheight);
  }

  el=getFirstElement(xmlDoc, "images");
  if(el)
  {
    thumbdir=getAttribute(el, "thumbsdir", thumbdir);
    imagedir=getAttribute(el, "imagesdir", imagedir);
    imagewidth=getIntAttribute(el, "width", imagewidth);
    imageheight=getIntAttribute(el, "height", imageheight);
    imagetarget=getAttribute(el, "target", imagetarget);
  }
  
  // now get all the images
  var imgs=xmlDoc.getElementsByTagName("image");
  images=new Array(imgs.length);
  thumbs=new Array(imgs.length);
  titles=new Array(imgs.length);
  descriptions=new Array(imgs.length);

  for(var i=0; i<imgs.length; i++)
  {
    var file=imgs[i].getAttribute("file");

    images[i]=imagedir+file;
    thumbs[i]=thumbdir+getAttribute(imgs[i], "thumb", file);
    titles[i]=getAttribute(imgs[i], "name", file);
    descriptions[i]=(imgs[i].firstChild) ? imgs[i].firstChild.nodeValue : TXT_ORIGSIZE;
  }

   if(thumbwidth || thumbheight)
  {
    thumbcellw=thumbwidth ? thumbwidth : Math.floor((thumbheight*4)/3);		// we expect 4:3 ratio
    thumbcellh=thumbheight ? thumbheight : Math.floor((thumbwidth*3)/4);  

    thumbcellw+=12;
    thumbcellh+=24;
  }
  else
  {
    thumbcellw="auto";
    thumbcellh="auto";
  }

  if(imagewidth || imageheight)
  {
    imagecellw=imagewidth ? imagewidth : Math.floor((imageheight*4)/3);		// we expect 4:3 ratio
    imagecellh=imageheight ? imageheight : Math.floor((imagewidth*3)/4);  

    imagecellw+=40;
    imagecellh+=40;
  }
  else
  {
    imagecellw="auto";
    imagecellh="auto";
  }
}

function getFirstElement(doc, tag)
{
  var els=doc.getElementsByTagName(tag);

  if(els.length>0)
    return els[0];
  else
    return null;
}

function getIntAttribute(el, attr, def)
{
  var val=getAttribute(el, attr, def);

  if(val)
    val=parseInt(val);

  return val;
}

function getAttribute(el, attr, def)
{
  var val=el.getAttribute(attr);

  if(val)
  {
    if(val=="null")
      return null;
    else
      return val;
  }
  else
    return def;
}

function getBrowserWidth()
{
  if(window.innerWidth)
    return window.innerWidth;
  else
    return document.body.clientWidth;
}

function getBrowserHeight()
{
  if(window.innerHeight)
    return window.innerHeight;
  else
    return document.body.clientHeight;
}
